#define _CRT_SECURE_NO_WARNINGS
#include <iostream>
#include <algorithm>
#include <vector>
#include <string>
#include <iomanip>
#include <stdio.h>
#include <random>
#include <cmath>
#include <set>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <deque>
#include <stack>
#include <queue>
#include <bitset>
#include <complex>
#include <numeric>
#include <climits>

using namespace std;

//#pragma GCC optimize("Ofast")

#define int long long
#define endl '\n'

mt19937_64 engine;
const long long mod = 1e9 + 7;
const long double eps = 1e-10;
const long double pi = acosl(-1.0);

long long sqr(long long x)
{
    return x * x;
}

long long mysqrt(long long x)
{
    long long l = 0;
    long long r = 1e9 + 1;
    while (r - l > 1)
    {
        long long m = (r + l) / 2;
        if (m * m <= x) l = m;
        else r = m;
    }
    return l;
}

long long gcd(long long x, long long y)
{
    if (y == 0) return x;
    return gcd(y, x % y);
}

long long lcm(long long x, long long y)
{
    return x / gcd(x, y) * y;
}

long long binpow(long long x, long long y)
{
    if (y == 0) return 1;
    if (y == 1) return x;
    int f = binpow(x, y / 2);
    if (y % 2 == 0) return (f * f) % mod;
    else return (((f * f) % mod) * x) % mod;
}

struct Vector
{
    int x, y;

    bool operator!=(Vector v1) const
    {
        return x != v1.x || y != v1.y;
    }
};

#define Point Vector

Vector make_vector(Point p1, Point p2)
{
    return { p2.x - p1.x, p2.y - p1.y };
}

int cross(Vector v1, Vector v2)
{
    return v1.x * v2.y - v1.y * v2.x;
}

bool intersec(pair<Point, Point> p1, pair<Point, Point> p2)
{
    Vector v1 = make_vector(p1.first, p1.second);
    Vector v2 = make_vector(p2.first, p2.second);

    if (v1.x * v2.y == v2.x * v1.y && p1.first != p2.first && p1.first != p2.second && p1.second != p2.first && p1.second != p2.second)
    {
        return false;
    }
    else if (v1.x * v2.y == v2.x * v1.y)
    {
        return true;
    }

    /*long double a1 = v1.y;
    long double b1 = -v1.x;
    long double c1 = -a1 * p1.first.x - b1 * p1.first.y;
    long double a2 = v2.y;
    long double b2 = -v2.x;
    long double c2 = -a2 * p2.first.x - b2 * p2.first.y;

    long double x = (c1 * b2 - c2 * b1) / (a2 * b1 - a1 * b2);
    long double y = (c2 * a1 - c1 * a2) / (a2 * b1 - a1 * b2);

    Point pp1 = p1.first;
    Point pp2 = p1.second;

    if (pp1.x > pp2.x) swap(pp1, pp2);
    if (x + eps < pp1.x || x - eps > pp2.x) return false;

    if (pp1.y > pp2.y) swap(pp1, pp2);
    if (y + eps < pp1.y || y - eps > pp2.y) return false;

    pp1 = p2.first;
    pp2 = p2.second;

    if (pp1.x > pp2.x) swap(pp1, pp2);
    if (x + eps < pp1.x || x - eps > pp2.x) return false;

    if (pp1.y > pp2.y) swap(pp1, pp2);
    if (y + eps < pp1.y || y - eps > pp2.y) return false;

    return true;*/

    Point pp1 = p1.first;
    Point pp2 = p1.second;
    Point pp3 = p2.first;
    Point pp4 = p2.second;

    int c1 = cross(make_vector(pp1, pp2), make_vector(pp1, pp3));
    int c2 = cross(make_vector(pp1, pp2), make_vector(pp1, pp4));
    int c3 = cross(make_vector(pp3, pp4), make_vector(pp3, pp1));
    int c4 = cross(make_vector(pp3, pp4), make_vector(pp3, pp2));

    int cnt1 = 0;
    int cnt2 = 0;
    int cnt3 = 0;
    int cnt4 = 0;

    if (c1 > 0) cnt1++;
    else if (c1 < 0) cnt2++;
    if (c2 > 0) cnt1++;
    else if (c2 < 0) cnt2++;
    if (c3 > 0) cnt3++;
    else if (c3 < 0) cnt4++;
    if (c4 > 0) cnt3++;
    else if (c4 < 0) cnt4++;

    if (cnt1 == 2 || cnt2 == 2 || cnt3 == 2 || cnt4 == 2)
    {
        return false;
    }
    else
    {
        return true;
    }
}

vector<int> parent;
vector<int> rnk;

int get_parent(int x)
{
    if (x != parent[x])
    {
        parent[x] = get_parent(parent[x]);
        return parent[x];
    }
    else return parent[x];
}

bool in_one(int x, int y)
{
    return get_parent(x) == get_parent(y);
}

void merge(int x, int y)
{
    x = get_parent(x);
    y = get_parent(y);

    if (rnk[x] > rnk[y])
    {
        parent[y] = x;
    }
    else if (rnk[x] < rnk[y])
    {
        parent[x] = y;
    }
    else
    {
        parent[y] = x;
        rnk[x]++;
    }
}

void task()
{
    parent.clear();
    rnk.clear();

    int n;
    cin >> n;

    parent.resize(n);
    rnk.resize(n, 1);
    for (int i = 0; i < n; i++)
    {
        parent[i] = i;
    }

    vector<pair<Point, Point>> v(n);
    for (int i = 0; i < n; i++)
    {
        cin >> v[i].first.x >> v[i].first.y;
        cin >> v[i].second.x >> v[i].second.y;
    }

    int ans = 1;
    for (int i = 0; i < n; i++)
    {
        for (int j = i + 1; j < n; j++)
        {
            if (intersec(v[i], v[j]))
            {
                if (!in_one(i, j))
                {
                    merge(i, j);
                }
                else
                {
                    ans++;
                }
            }
        }
    }

    cout << ans << endl;
}

signed main()
{
    //freopen("in.txt", "r", stdin);
    //freopen("out.txt", "w", stdout);

    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    cout << fixed << setprecision(15);
    engine.seed(58);

    bool multitest = 1;
    int t = 1;
    if (multitest) cin >> t;
    while (t--) task();

    return 0;
}
